/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableBooleanProperty
extends BooleanPropertyBase
implements StyleableProperty<Boolean> {
    private StyleOrigin origin = null;
    private TransitionMediatorImpl mediator = null;

    public StyleableBooleanProperty() {
    }

    public StyleableBooleanProperty(boolean bl) {
        super(bl);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, Boolean bl) {
        boolean bl2;
        TransitionDefinition transitionDefinition;
        Object object;
        if (this.origin != null && (object = this.getBean()) instanceof Node) {
            Node node = (Node)object;
            transitionDefinition = NodeHelper.findTransitionDefinition(node, this.getCssMetaData());
        } else {
            transitionDefinition = null;
        }
        TransitionDefinition transitionDefinition2 = transitionDefinition;
        boolean bl3 = bl2 = bl != null && bl != false;
        if (transitionDefinition2 == null) {
            this.set(bl2);
        } else if (this.mediator == null || this.mediator.newValue != bl2) {
            this.mediator = new TransitionMediatorImpl(this.get(), bl2);
            this.mediator.run(transitionDefinition2);
        }
        this.origin = styleOrigin;
    }

    @Override
    public void bind(ObservableValue<? extends Boolean> observableValue) {
        super.bind(observableValue);
        this.origin = StyleOrigin.USER;
        if (this.mediator != null) {
            this.mediator.cancel(true);
        }
    }

    @Override
    public void set(boolean bl) {
        super.set(bl);
        if (this.mediator == null || this.mediator.cancel(false)) {
            this.origin = StyleOrigin.USER;
        }
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private class TransitionMediatorImpl
    extends TransitionMediator {
        private final boolean oldValue;
        private final boolean newValue;

        public TransitionMediatorImpl(boolean bl, boolean bl2) {
            this.oldValue = bl;
            this.newValue = bl2;
        }

        @Override
        public void onUpdate(double d) {
            StyleableBooleanProperty.this.set(d > 0.0 ? this.newValue : this.oldValue);
        }

        @Override
        public void onStop() {
            if (StyleableBooleanProperty.this.mediator == this) {
                StyleableBooleanProperty.this.mediator = null;
            }
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return StyleableBooleanProperty.this;
        }
    }
}

