/*
 * Decompiled with CFR 0.152.
 */
package de.pixelmedien.adventure.ui.rooms;

import de.pixelmedien.adventure.game.audio.SoundController;
import de.pixelmedien.adventure.game.item.Item;
import de.pixelmedien.adventure.game.player.Player;
import de.pixelmedien.adventure.game.player.PlayerController;
import de.pixelmedien.adventure.ui.InventoryController;
import de.pixelmedien.adventure.ui.RoomController;
import de.pixelmedien.adventure.ui.SceneController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.util.Duration;

public class BedroomController
extends RoomController {
    @FXML
    private AnchorPane root;
    @FXML
    private ImageView bedroomBackground;
    @FXML
    private Group playerGroup;
    @FXML
    private ImageView playerAvatar;
    @FXML
    private Rectangle playerHitbox;
    @FXML
    private ScrollPane storyScrollPane;
    @FXML
    private TextFlow storyText;
    @FXML
    private ImageView bedImage;
    @FXML
    private Rectangle bedCollider;
    @FXML
    private ImageView doorCarpetImage;
    @FXML
    private ImageView shelfImage;
    @FXML
    private ImageView vesselImage;
    @FXML
    private Rectangle shelfCollider;
    @FXML
    private Rectangle leftWall;
    @FXML
    private Rectangle leftWallCenter;
    @FXML
    private Rectangle rightWall;
    @FXML
    private Rectangle rightWallCenter;
    @FXML
    private Rectangle topWallLeft;
    @FXML
    private Rectangle topWallRight;
    @FXML
    private Rectangle topWallCenter;
    @FXML
    private Rectangle bottomWallLeft;
    @FXML
    private Rectangle bottomWallRight;
    @FXML
    private Rectangle bottomWallCenter;
    private static final Logger LOGGER = Logger.getLogger(BedroomController.class.getName());
    private final List<Node> colliders = new ArrayList<Node>();
    private final List<Text> currentChoiceLinks = new ArrayList<Text>();
    private PlayerController playerController;
    private SceneController sceneController;
    private Player player;
    private InventoryController inventoryController;
    private boolean shelfInspected = false;

    @FXML
    public void initialize() {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/ui/interface/inventory.fxml"));
            Node inventoryUI = (Node)loader.load();
            this.inventoryController = (InventoryController)loader.getController();
            this.root.getChildren().add(inventoryUI);
            AnchorPane.setTopAnchor(inventoryUI, 10.0);
            AnchorPane.setRightAnchor(inventoryUI, 10.0);
        }
        catch (IOException exception) {
            LOGGER.log(Level.SEVERE, "Fehler beim Laden des Inventar-UI.", exception);
        }
        this.colliders.add(this.leftWall);
        this.colliders.add(this.leftWallCenter);
        this.colliders.add(this.rightWall);
        this.colliders.add(this.rightWallCenter);
        this.colliders.add(this.topWallLeft);
        this.colliders.add(this.topWallRight);
        this.colliders.add(this.topWallCenter);
        this.colliders.add(this.bottomWallLeft);
        this.colliders.add(this.bottomWallRight);
        this.colliders.add(this.bottomWallCenter);
        this.colliders.add(this.shelfCollider);
        this.colliders.add(this.bedCollider);
        this.appendDialog(this.storyText, "Du erwachst in einem unbekannten Raum...\nWillst du den Raum erkunden?\n");
        this.setRoomClickable(false);
        this.createChoiceLinks();
        this.bedImage.getStyleClass().add("clickable");
        this.bedImage.setOnMouseClicked(this::onBedClicked);
        this.doorCarpetImage.getStyleClass().add("clickable");
        this.doorCarpetImage.setOnMouseClicked(this::onDoorClicked);
        this.shelfImage.getStyleClass().add("clickable");
        this.shelfImage.setOnMouseClicked(this::onShelfClicked);
        this.vesselImage.getStyleClass().add("clickable");
        this.vesselImage.setOnMouseClicked(this::onVesselClicked);
        this.vesselImage.setDisable(true);
        this.player = new Player("Held", this.playerAvatar, this.playerHitbox);
        this.playerController = new PlayerController(this.player);
        this.playerController.setColliders(this.colliders);
        this.playerHitbox.xProperty().bind(this.playerAvatar.layoutXProperty().add(this.playerAvatar.fitWidthProperty().multiply(0.3)));
        this.playerHitbox.yProperty().bind(this.playerAvatar.layoutYProperty().add(this.playerAvatar.fitHeightProperty().multiply(0.6)));
        this.playerHitbox.widthProperty().bind(this.playerAvatar.fitWidthProperty().multiply(0.4));
        this.playerHitbox.heightProperty().bind(this.playerAvatar.fitHeightProperty().multiply(0.2));
        Platform.runLater(() -> this.playerController.start());
        this.bedroomBackground.setOnMouseClicked(this::onBackgroundClicked);
    }

    private void createChoiceLinks() {
        this.appendLink(this.storyText, "Raum erkunden", this::startExploring, this.currentChoiceLinks);
        this.appendLink(this.storyText, "Nein, liegenbleiben", this::quitGame, this.currentChoiceLinks);
    }

    private void startExploring() {
        this.setRoomClickable(true);
        this.appendDialog(this.storyText, "Du stehst auf und beginnst, den Raum zu erkunden...");
        this.playerAvatar.setVisible(true);
        this.playerGroup.toFront();
        double startX = this.bedImage.getLayoutX() + this.bedImage.getFitWidth() + 10.0;
        double startY = this.bedImage.getLayoutY();
        this.playerAvatar.setLayoutX(startX);
        this.playerAvatar.setLayoutY(startY);
        this.player.setPosition(startX, startY);
        this.player.setTarget(startX, startY);
    }

    private void quitGame() {
        this.appendDialog(this.storyText, "Du bleibst liegen... Spiel wird beendet.");
        PauseTransition delay = new PauseTransition(Duration.seconds(2.0));
        delay.setOnFinished(event -> this.sceneController.setScene("/ui/gameover.fxml", "Who Am I - Game Over"));
        delay.play();
    }

    private void setRoomClickable(boolean clickable) {
        this.bedImage.setDisable(!clickable);
        this.doorCarpetImage.setDisable(!clickable);
        this.shelfImage.setDisable(!clickable);
    }

    private void onBackgroundClicked(MouseEvent event) {
        if (!this.playerAvatar.isVisible()) {
            return;
        }
        this.playerController.moveTo(event.getX(), event.getY());
    }

    private void onBedClicked(MouseEvent event) {
        double targetX = this.bedImage.getLayoutX() + this.bedImage.getFitWidth() / 2.0 + this.playerAvatar.getFitWidth() / 2.0;
        double targetY = this.bedImage.getLayoutY() + this.bedImage.getFitHeight() / 2.0;
        this.playerController.moveTo(targetX, targetY);
        this.playerController.setOnReachedTarget(() -> {
            this.appendSFX(this.storyText, "Du betrachtest das Bett. Es sieht gem\u00fctlich aus, aber du hast keine Erinnerung...");
            this.soundController.playSfxWithPause("bed.mp3");
        });
    }

    private void onDoorClicked(MouseEvent event) {
        double targetX = this.doorCarpetImage.getLayoutX() + this.doorCarpetImage.getFitWidth() / 2.0;
        double targetY = this.doorCarpetImage.getLayoutY() + this.doorCarpetImage.getFitHeight() / 2.0 - this.playerAvatar.getFitHeight() / 6.0;
        this.playerController.moveTo(targetX, targetY);
        this.playerController.setOnReachedTarget(() -> {
            if (this.inventoryController.hasItem("bedroom-key")) {
                this.appendSFX(this.storyText, "Geschafft! Die T\u00fcr ist jetzt offen...");
                this.soundController.playSfxWithPause("door-open.mp3");
                PauseTransition delay = new PauseTransition(Duration.seconds(2.0));
                delay.setOnFinished(e -> this.sceneController.setScene("/ui/gameover.fxml", "Who Am I - Game Over"));
                delay.play();
            } else {
                this.appendSFX(this.storyText, "Hmmm, verschlossen. Wie komme ich hier raus...");
                this.soundController.playSfxWithPause("door-locked.mp3");
            }
        });
    }

    private void onShelfClicked(MouseEvent event) {
        double targetX = this.shelfImage.getLayoutX() + this.shelfImage.getFitWidth() / 2.0;
        double targetY = this.shelfImage.getLayoutY() + this.shelfImage.getFitHeight() / 2.0 + this.playerAvatar.getFitHeight() / 2.0;
        this.playerController.moveTo(targetX, targetY);
        this.playerController.setOnReachedTarget(() -> {
            if (!this.shelfInspected) {
                this.appendSFX(this.storyText, "Vielleicht finde ich etwas in diesem Regal...\n\nHmmm... im Regal selber nichts....\n\nOh auf dem Regal steht eine Vase! Vielleicht ist da ja was drin...");
                this.soundController.playSfxWithPause("shelf.mp3");
                this.shelfInspected = true;
                this.vesselImage.setDisable(false);
            } else {
                this.appendSFX(this.storyText, "Du hast das Regal bereits durchsucht.");
            }
        });
    }

    private void onVesselClicked(MouseEvent event) {
        double deltaY;
        double deltaX = this.player.getX() - (this.shelfImage.getLayoutX() + this.shelfImage.getFitWidth() / 2.0);
        double distance = Math.sqrt(deltaX * deltaX + (deltaY = this.player.getY() - (this.shelfImage.getLayoutY() + this.shelfImage.getFitHeight() / 2.0 + this.playerAvatar.getFitHeight() / 2.0)) * deltaY);
        if (distance > 10.0) {
            double targetX = this.shelfImage.getLayoutX() + this.shelfImage.getFitWidth() / 2.0;
            double targetY = this.shelfImage.getLayoutY() + this.shelfImage.getFitHeight() / 2.0 + this.playerAvatar.getFitHeight() / 2.0;
            this.playerController.moveTo(targetX, targetY);
            this.playerController.setOnReachedTarget(this::showVesselChoice);
        } else {
            this.showVesselChoice();
        }
    }

    private void showVesselChoice() {
        this.storyText.getChildren().clear();
        if (this.inventoryController.hasItem("bedroom-key")) {
            this.appendSFX(this.storyText, "Die Vase ist leer.");
            return;
        }
        this.appendDialog(this.storyText, "Willst du die Vase durchsuchen?");
        this.appendLink(this.storyText, "Ja", this::searchVessel, this.currentChoiceLinks);
        this.appendLink(this.storyText, "Nein", () -> {
            this.storyText.getChildren().clear();
            this.appendSFX(this.storyText, "Du entscheidest dich, die Vase nicht zu durchsuchen.");
        }, this.currentChoiceLinks);
    }

    private void searchVessel() {
        this.storyText.getChildren().clear();
        if (this.inventoryController.hasItem("bedroom-key")) {
            this.appendSFX(this.storyText, "Die Vase ist leer.");
            return;
        }
        this.appendSFX(this.storyText, "Du \u00f6ffnest die Vase und findest einen Zimmerschl\u00fcssel!");
        this.soundController.playSfxWithPause("vessel.mp3");
        this.showKeyChoice();
    }

    private void showKeyChoice() {
        if (this.inventoryController.hasItem("bedroom-key")) {
            this.appendSFX(this.storyText, "Die Vase ist leer.");
            return;
        }
        this.appendDialog(this.storyText, "Willst du den Schl\u00fcssel aufnehmen?");
        this.appendLink(this.storyText, "Ja", this::takeKey, this.currentChoiceLinks);
        this.appendLink(this.storyText, "Nein", () -> {
            this.storyText.getChildren().clear();
            this.appendSFX(this.storyText, "Du l\u00e4sst den Schl\u00fcssel in der Vase liegen.");
        }, this.currentChoiceLinks);
    }

    private void takeKey() {
        this.storyText.getChildren().clear();
        if (this.inventoryController.hasItem("bedroom-key")) {
            this.appendSFX(this.storyText, "Du hast den Schl\u00fcssel bereits aufgenommen.");
            return;
        }
        this.appendSFX(this.storyText, "Du nimmst den Schl\u00fcssel auf!");
        this.soundController.playSfxWithPause("key.mp3");
        this.inventoryController.addItem(new Item("bedroom-key", "/images/inventory/inventory-slot-key.png"));
    }

    @Override
    public void setSoundController(SoundController soundController) {
        this.soundController = soundController;
        soundController.playMusic("bedroom-theme.mp3", true);
    }

    @Override
    public void setSceneController(SceneController sceneController) {
        this.sceneController = sceneController;
    }
}

