/*
 * Decompiled with CFR 0.152.
 */
package de.pixelmedien.adventure.ui;

import de.pixelmedien.adventure.game.audio.SoundController;
import de.pixelmedien.adventure.game.player.PlayerController;
import de.pixelmedien.adventure.ui.GameController;
import java.io.IOException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class SceneController {
    private static final Logger LOGGER = Logger.getLogger(SceneController.class.getName());
    private final Stage mainStage;
    private final SoundController soundController;
    private final PlayerController playerController;

    public SceneController(Stage stage, SoundController soundController, PlayerController playerController) {
        this.mainStage = stage;
        this.soundController = soundController;
        this.playerController = playerController;
    }

    public void setScene(String fxmlPath, String title) {
        try {
            FXMLLoader loader = new FXMLLoader(SceneController.class.getResource(fxmlPath));
            Parent root = (Parent)loader.load();
            Object controller = loader.getController();
            if (controller instanceof GameController) {
                GameController gameController = (GameController)controller;
                gameController.setSoundController(this.soundController);
                gameController.setPlayerController(this.playerController);
                gameController.setSceneController(this);
            }
            Scene scene = new Scene(root);
            scene.getStylesheets().add(Objects.requireNonNull(SceneController.class.getResource("/css/game.css")).toExternalForm());
            this.mainStage.setTitle(title);
            this.mainStage.setScene(scene);
        }
        catch (IOException exception) {
            LOGGER.log(Level.SEVERE, "Fehler beim Laden der Szene: " + fxmlPath, exception);
        }
    }
}

