/*
 * Decompiled with CFR 0.152.
 */
package de.pixelmedien.adventure.ui;

import de.pixelmedien.adventure.game.item.Item;
import javafx.fxml.FXML;
import javafx.scene.image.ImageView;

public class InventoryController {
    @FXML
    private ImageView inventorySlot1;
    @FXML
    private ImageView inventorySlot2;
    @FXML
    private ImageView inventorySlot3;
    private final Item[] slots = new Item[3];

    @FXML
    public void initialize() {
        this.refreshUI();
    }

    public void addItem(Item item) {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] != null) continue;
            this.slots[i] = item;
            this.refreshUI();
            return;
        }
    }

    public boolean hasItem(String id) {
        for (Item slot : this.slots) {
            if (slot == null || !slot.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    private void refreshUI() {
        this.updateSlot(this.inventorySlot1, this.slots[0]);
        this.updateSlot(this.inventorySlot2, this.slots[1]);
        this.updateSlot(this.inventorySlot3, this.slots[2]);
    }

    private void updateSlot(ImageView slotView, Item item) {
        if (item == null) {
            slotView.setImage(null);
        } else {
            slotView.setImage(item.getImage());
        }
    }
}

