/*
 * Decompiled with CFR 0.152.
 */
package de.pixelmedien.adventure.ui;

import de.pixelmedien.adventure.game.audio.SoundController;
import de.pixelmedien.adventure.ui.GameController;
import de.pixelmedien.adventure.ui.SceneController;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.logging.Logger;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.PauseTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class GameOverController
implements GameController {
    @FXML
    private VBox creditsContainer;
    @FXML
    private VBox endContainer;
    @FXML
    private StackPane creditsStack;
    @FXML
    private Text endLogoText;
    @FXML
    private Text creditsText;
    @FXML
    private Text endText;
    @FXML
    private ImageView endLogo;
    @FXML
    private Label restartLabel;
    private SceneController sceneController;
    private static final Logger LOGGER = Logger.getLogger(GameOverController.class.getName());

    @FXML
    public void initialize() {
        this.loadCredits();
        this.loadEndLogo();
        this.creditsContainer.sceneProperty().addListener((obs, oldScene, newScene) -> {
            if (newScene != null) {
                newScene.windowProperty().addListener((obsWin, oldWin, newWin) -> {
                    if (newWin != null) {
                        this.startCreditScroll();
                    }
                });
            }
        });
    }

    @FXML
    private void onRestartClicked() {
        if (this.sceneController != null) {
            this.sceneController.setScene("/ui/rooms/bedroom.fxml", "Who Am I - Schlafzimmer");
        } else {
            LOGGER.warning("SceneController ist null \u2013 Neustart nicht m\u00f6glich!");
        }
    }

    private void loadCredits() {
        try (InputStream is = this.getClass().getResourceAsStream("/credits/credits.txt");){
            if (is != null) {
                String credits = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                this.creditsText.setText(credits);
            } else {
                this.creditsText.setText("Credits-Datei nicht gefunden!");
                LOGGER.warning("Credits-Datei nicht gefunden!");
            }
        }
        catch (IOException exception) {
            this.creditsText.setText("Fehler beim Laden der Credits!");
            LOGGER.severe("Fehler beim Laden der credits.txt: " + exception.getMessage());
        }
    }

    private void loadEndLogo() {
        try {
            Image logo = new Image(Objects.requireNonNull(this.getClass().getResourceAsStream("/images/credits/pixel-medien-white.png")));
            this.endLogo.setImage(logo);
        }
        catch (Exception exception) {
            LOGGER.warning("Endlogo konnte nicht geladen werden: " + exception.getMessage());
        }
    }

    private void startCreditScroll() {
        Platform.runLater(() -> {
            double sceneHeight = this.creditsStack.getHeight();
            double creditsHeight = this.creditsContainer.getBoundsInParent().getHeight();
            this.creditsContainer.setTranslateY(sceneHeight);
            double targetY = -creditsHeight + sceneHeight;
            double scrollSpeed = 50.0;
            double distance = sceneHeight + creditsHeight;
            double durationSeconds = distance / scrollSpeed;
            TranslateTransition scroll = new TranslateTransition(Duration.seconds(durationSeconds), this.creditsContainer);
            scroll.setFromY(sceneHeight);
            scroll.setToY(targetY);
            scroll.setInterpolator(Interpolator.LINEAR);
            scroll.setOnFinished(event -> {
                PauseTransition pause = new PauseTransition(Duration.seconds(5.0));
                pause.setOnFinished(e -> this.fadeOutCredits());
                pause.play();
            });
            scroll.play();
        });
    }

    private void fadeOutCredits() {
        this.endContainer.setVisible(true);
        this.endText.setOpacity(0.0);
        this.endLogo.setOpacity(0.0);
        this.endLogoText.setOpacity(0.0);
        this.restartLabel.setOpacity(0.0);
        FadeTransition fade = new FadeTransition(Duration.seconds(2.0), this.creditsContainer);
        fade.setFromValue(1.0);
        fade.setToValue(0.0);
        fade.setOnFinished(event -> this.showEndScreen());
        fade.play();
    }

    private void showEndScreen() {
        this.endText.setVisible(true);
        this.endLogo.setVisible(true);
        this.endLogoText.setVisible(true);
        this.restartLabel.setVisible(true);
        FadeTransition textFade = new FadeTransition(Duration.seconds(2.0), this.endText);
        textFade.setFromValue(0.0);
        textFade.setToValue(1.0);
        FadeTransition logoFade = new FadeTransition(Duration.seconds(2.0), this.endLogo);
        logoFade.setFromValue(0.0);
        logoFade.setToValue(1.0);
        FadeTransition restartFade = new FadeTransition(Duration.seconds(2.0), this.restartLabel);
        restartFade.setFromValue(0.0);
        restartFade.setToValue(1.0);
        FadeTransition logoTextFade = new FadeTransition(Duration.seconds(2.0), this.endLogoText);
        logoTextFade.setFromValue(0.0);
        logoTextFade.setToValue(1.0);
        ParallelTransition pt = new ParallelTransition(textFade, logoFade, restartFade, logoTextFade);
        pt.play();
    }

    @Override
    public void setSoundController(SoundController soundController) {
        soundController.playMusic("start-theme.mp3", true);
    }

    @Override
    public void setSceneController(SceneController sceneController) {
        this.sceneController = sceneController;
    }
}

