/*
 * Decompiled with CFR 0.152.
 */
package de.pixelmedien.adventure.game.player;

import de.pixelmedien.adventure.game.player.Player;
import de.pixelmedien.adventure.game.player.PlayerState;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.AnimationTimer;
import javafx.geometry.Bounds;
import javafx.scene.Node;

public class PlayerController {
    private final Player player;
    private AnimationTimer gameLoop;
    private Runnable onReachedTarget;
    private List<Node> colliders = new ArrayList<Node>();

    public PlayerController(Player player) {
        this.player = player;
        if (player != null) {
            player.setTarget(player.getX(), player.getY());
        }
    }

    public void start() {
        this.gameLoop = new AnimationTimer(){

            @Override
            public void handle(long now) {
                PlayerController.this.update();
            }
        };
        this.gameLoop.start();
    }

    private void update() {
        boolean moved;
        double vertikal;
        double tolerance;
        double dx = this.player.getTargetX() - this.player.getX();
        double dy = this.player.getTargetY() - this.player.getY();
        if (Math.abs(dx) < 3.0 && Math.abs(dy) < 3.0) {
            this.player.setCurrentState(PlayerState.IDLE);
            if (this.onReachedTarget != null) {
                this.onReachedTarget.run();
                this.onReachedTarget = null;
            }
            return;
        }
        double step = this.player.getSpeed();
        double stepX = Math.abs(dx) > 1.0 ? Math.signum(dx) * step : 0.0;
        double stepY = Math.abs(dy) > 1.0 ? Math.signum(dy) * step : 0.0;
        double horizontal = Math.abs(dx);
        if (horizontal * (tolerance = 10.0) > (vertikal = Math.abs(dy))) {
            if (stepX != 0.0) {
                this.player.setCurrentState(dx > 0.0 ? PlayerState.RIGHT : PlayerState.LEFT);
            }
        } else if (vertikal * tolerance > horizontal && stepY != 0.0) {
            this.player.setCurrentState(dy > 0.0 ? PlayerState.DOWN : PlayerState.UP);
        }
        boolean bl = moved = this.tryMoveStep(stepX, 0.0) || this.tryMoveStep(0.0, stepY);
        if (!moved && !this.tryMoveStep(0.0, stepY)) {
            this.tryMoveStep(stepX, 0.0);
        }
    }

    private boolean tryMoveStep(double offsetX, double offsetY) {
        if (offsetX == 0.0 && offsetY == 0.0) {
            return false;
        }
        Bounds test = this.player.getFootBounds(offsetX, offsetY);
        boolean blocked = this.colliders.stream().map(Node::getBoundsInParent).anyMatch(cb -> cb.intersects(test));
        if (!blocked) {
            this.player.setPosition(this.player.getX() + offsetX, this.player.getY() + offsetY);
            return true;
        }
        return false;
    }

    public void moveTo(double x, double y) {
        double correctedX = x - this.player.getAvatar().getFitWidth() / 2.0;
        double footOffset = this.player.getAvatar().getFitHeight() / 2.0;
        double correctedY = y - footOffset;
        this.player.setTarget(correctedX, correctedY);
        this.onReachedTarget = null;
    }

    public void setOnReachedTarget(Runnable action) {
        this.onReachedTarget = action;
    }

    public void setColliders(List<Node> colliders) {
        this.colliders = colliders;
    }
}

