/*
 * Decompiled with CFR 0.152.
 */
package de.pixelmedien.adventure.game.player;

import de.pixelmedien.adventure.game.animation.SpriteAnimation;
import de.pixelmedien.adventure.game.animation.SpriteLoader;
import de.pixelmedien.adventure.game.player.PlayerState;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.image.ImageView;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class Player {
    private final String name;
    private final ImageView avatar;
    private final Rectangle hitbox;
    private double x;
    private double y;
    private double targetX;
    private double targetY;
    private double speed = 1.0;
    private final SpriteLoader loader = new SpriteLoader("/images/player/");
    private final SpriteAnimation walkUpAnimation;
    private final SpriteAnimation walkDownAnimation;
    private final SpriteAnimation walkLeftAnimation;
    private final SpriteAnimation walkRightAnimation;
    private SpriteAnimation currentAnimation;
    public PlayerState currentState = PlayerState.IDLE;

    public Player(String name, ImageView avatar, Rectangle hitbox) {
        this.name = name;
        this.avatar = avatar;
        this.hitbox = hitbox;
        if (avatar != null) {
            this.x = avatar.getLayoutX();
            this.y = avatar.getLayoutY();
        }
        this.walkUpAnimation = new SpriteAnimation(avatar, this.loader.loadWalkUpFrames(), Duration.millis(150.0));
        this.walkDownAnimation = new SpriteAnimation(avatar, this.loader.loadWalkDownFrames(), Duration.millis(150.0));
        this.walkLeftAnimation = new SpriteAnimation(avatar, this.loader.loadWalkLeftFrames(), Duration.millis(150.0));
        this.walkRightAnimation = new SpriteAnimation(avatar, this.loader.loadWalkRightFrames(), Duration.millis(150.0));
    }

    private void updateSpriteForState(PlayerState state) {
        if (this.currentAnimation != null) {
            this.currentAnimation.stop();
        }
        switch (state) {
            case UP: {
                this.currentAnimation = this.walkUpAnimation;
                this.currentAnimation.play();
                break;
            }
            case DOWN: {
                this.currentAnimation = this.walkDownAnimation;
                this.currentAnimation.play();
                break;
            }
            case LEFT: {
                this.currentAnimation = this.walkLeftAnimation;
                this.currentAnimation.play();
                break;
            }
            case RIGHT: {
                this.currentAnimation = this.walkRightAnimation;
                this.currentAnimation.play();
                break;
            }
            case IDLE: {
                this.avatar.setImage(this.loader.loadIdleFrame());
                this.currentAnimation = null;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public ImageView getAvatar() {
        return this.avatar;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getTargetX() {
        return this.targetX;
    }

    public double getTargetY() {
        return this.targetY;
    }

    public double getSpeed() {
        return this.speed;
    }

    public PlayerState getCurrentState() {
        return this.currentState;
    }

    public Bounds getFootBounds() {
        return this.hitbox.getBoundsInParent();
    }

    public Bounds getFootBounds(double offsetX, double offsetY) {
        return new BoundingBox(this.avatar.getLayoutX() + offsetX + this.avatar.getFitWidth() * 0.3, this.avatar.getLayoutY() + offsetY + this.avatar.getFitHeight() * 0.6, this.avatar.getFitWidth() * 0.4, this.avatar.getFitHeight() * 0.2);
    }

    public void setPosition(double x, double y) {
        this.x = x;
        this.y = y;
        if (this.avatar != null) {
            this.avatar.setLayoutX(x);
            this.avatar.setLayoutY(y);
        }
    }

    public void setTarget(double targetX, double targetY) {
        this.targetX = targetX;
        this.targetY = targetY;
    }

    public void setSpeed(double speed) {
        if (speed > 0.0) {
            this.speed = speed;
        }
    }

    public void setCurrentState(PlayerState state) {
        if (this.currentState != state) {
            this.currentState = state;
            this.updateSpriteForState(state);
        }
    }
}

