/*
 * Decompiled with CFR 0.152.
 */
package de.pixelmedien.adventure.game.audio;

import de.pixelmedien.adventure.game.audio.SoundState;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.media.Media;
import javafx.scene.media.MediaException;
import javafx.scene.media.MediaPlayer;

public class SoundController {
    private static final Logger LOGGER = Logger.getLogger(SoundController.class.getName());
    private final Map<String, Media> mediaCache = new ConcurrentHashMap<String, Media>();
    private MediaPlayer musicPlayer;
    private String currentMusicFile;
    private double musicVolume = 0.1;
    private double sfxVolume = 0.5;
    private final double duckFactor = 0.25;
    private volatile SoundState soundState = SoundState.STOPPED;

    public double getMusicVolume() {
        return this.musicVolume;
    }

    public double getSfxVolume() {
        return this.sfxVolume;
    }

    public SoundState getMusicState() {
        return this.soundState;
    }

    public void setMusicVolume(double volume) {
        this.musicVolume = this.clamp(volume);
        this.runOnFx(() -> {
            if (this.musicPlayer != null) {
                this.musicPlayer.setVolume(this.musicVolume);
            }
        });
    }

    public void setSfxVolume(double volume) {
        this.sfxVolume = this.clamp(volume);
    }

    public synchronized void playMusic(String filename, boolean loop) {
        Objects.requireNonNull(filename, "filename darf nicht null sein");
        this.runOnFx(() -> {
            try {
                if (filename.equals(this.currentMusicFile) && this.musicPlayer != null) {
                    if (this.soundState == SoundState.PAUSED) {
                        this.musicPlayer.play();
                        this.soundState = SoundState.PLAYING;
                        LOGGER.fine("Resumed existing music: " + filename);
                    } else if (this.soundState == SoundState.PLAYING) {
                        LOGGER.fine("Music already playing: " + filename);
                    }
                    if (loop && this.musicPlayer.getCycleCount() != -1) {
                        this.musicPlayer.setCycleCount(-1);
                    }
                    return;
                }
                this.stopMusicInternal(false);
                Media media = this.loadMedia("/audio/music/" + filename);
                this.musicPlayer = new MediaPlayer(media);
                this.currentMusicFile = filename;
                this.musicPlayer.setVolume(this.musicVolume);
                this.musicPlayer.setCycleCount(loop ? -1 : 1);
                this.musicPlayer.setOnError(() -> LOGGER.log(Level.WARNING, "Music player error: " + String.valueOf(this.musicPlayer.getError()), this.musicPlayer.getError()));
                media.setOnError(() -> LOGGER.log(Level.WARNING, "Media error: " + String.valueOf(media.getError()), media.getError()));
                this.musicPlayer.setOnEndOfMedia(() -> {
                    if (!loop) {
                        this.soundState = SoundState.STOPPED;
                        LOGGER.fine("Music ended: " + filename);
                    }
                });
                this.musicPlayer.play();
                this.soundState = SoundState.PLAYING;
                LOGGER.fine("Started music: " + filename);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Failed to play music: " + filename, exception);
            }
        });
    }

    public synchronized void pauseMusic() {
        this.runOnFx(() -> {
            if (this.musicPlayer != null && this.soundState == SoundState.PLAYING) {
                this.musicPlayer.pause();
                this.soundState = SoundState.PAUSED;
                LOGGER.fine("Music paused");
            }
        });
    }

    public synchronized void resumeMusic() {
        this.runOnFx(() -> {
            if (this.musicPlayer != null && this.soundState == SoundState.PAUSED) {
                this.musicPlayer.play();
                this.soundState = SoundState.PLAYING;
                LOGGER.fine("Music resumed");
            } else if (this.musicPlayer != null && this.soundState == SoundState.STOPPED) {
                this.musicPlayer.play();
                this.soundState = SoundState.PLAYING;
                LOGGER.fine("Music started from stopped state");
            }
        });
    }

    public synchronized void stopMusic() {
        this.runOnFx(() -> this.stopMusicInternal(true));
    }

    public void playSfx(String filename) {
        Objects.requireNonNull(filename, "filename darf nicht null sein");
        this.runOnFx(() -> {
            try {
                Media media = this.loadMedia("/audio/sfx/" + filename);
                MediaPlayer sfxPlayer = new MediaPlayer(media);
                sfxPlayer.setVolume(this.sfxVolume);
                sfxPlayer.setOnError(() -> LOGGER.log(Level.WARNING, "SFX player error: " + String.valueOf(sfxPlayer.getError()), sfxPlayer.getError()));
                media.setOnError(() -> LOGGER.log(Level.WARNING, "SFX media error: " + String.valueOf(media.getError()), media.getError()));
                sfxPlayer.setOnEndOfMedia(() -> {
                    try {
                        sfxPlayer.dispose();
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.WARNING, "Error disposing sfx player", exception);
                    }
                });
                sfxPlayer.play();
                LOGGER.fine("Played sfx: " + filename);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Failed to play sfx: " + filename, exception);
            }
        });
    }

    public void playSfxWithPause(String filename) {
        Objects.requireNonNull(filename, "filename darf nicht null sein");
        this.runOnFx(() -> {
            try {
                double prevMusicVol;
                Media media = this.loadMedia("/audio/sfx/" + filename);
                MediaPlayer sfxPlayer = new MediaPlayer(media);
                sfxPlayer.setVolume(this.sfxVolume);
                sfxPlayer.setOnError(() -> LOGGER.log(Level.WARNING, "SFX player error: " + String.valueOf(sfxPlayer.getError()), sfxPlayer.getError()));
                media.setOnError(() -> LOGGER.log(Level.WARNING, "SFX media error: " + String.valueOf(media.getError()), media.getError()));
                double d = prevMusicVol = this.musicPlayer != null ? this.musicPlayer.getVolume() : this.musicVolume;
                if (this.musicPlayer != null && this.soundState == SoundState.PLAYING) {
                    this.musicPlayer.setVolume(prevMusicVol * 0.25);
                    LOGGER.fine("Music ducked for sfx: " + filename);
                }
                sfxPlayer.setOnEndOfMedia(() -> {
                    try {
                        sfxPlayer.dispose();
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.WARNING, "Error disposing sfx player", exception);
                    }
                    if (this.musicPlayer != null) {
                        this.musicPlayer.setVolume(this.musicVolume);
                        if (this.soundState != SoundState.PAUSED) {
                            this.soundState = SoundState.PLAYING;
                        }
                        LOGGER.fine("Music restored after sfx: " + filename);
                    }
                });
                sfxPlayer.play();
                LOGGER.fine("Played sfx with pause/duck: " + filename);
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Failed to play sfx with pause: " + filename, exception);
            }
        });
    }

    private void stopMusicInternal(boolean disposePlayer) {
        block5: {
            if (this.musicPlayer != null) {
                try {
                    this.musicPlayer.stop();
                    if (disposePlayer) {
                        this.musicPlayer.dispose();
                        this.musicPlayer = null;
                        this.currentMusicFile = null;
                        this.soundState = SoundState.STOPPED;
                        LOGGER.fine("Music stopped and disposed");
                        break block5;
                    }
                    this.soundState = SoundState.STOPPED;
                    LOGGER.fine("Music stopped (not disposed)");
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Error stopping music", exception);
                }
            } else {
                this.soundState = SoundState.STOPPED;
            }
        }
    }

    private Media loadMedia(String resourcePath) {
        return this.mediaCache.computeIfAbsent(resourcePath, key -> {
            try {
                URL url = this.getClass().getResource((String)key);
                if (url == null) {
                    throw new IllegalArgumentException("Resource not found: " + key);
                }
                Media m = new Media(url.toExternalForm());
                m.setOnError(() -> LOGGER.log(Level.WARNING, "Media load error for: " + key, m.getError()));
                return m;
            }
            catch (MediaException me) {
                LOGGER.log(Level.SEVERE, "MediaException loading " + key, me);
                throw me;
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Error loading media " + key, exception);
                throw new RuntimeException(exception);
            }
        });
    }

    private void runOnFx(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater(runnable);
        }
    }

    private double clamp(double value) {
        return Math.max(0.0, Math.min(1.0, value));
    }
}

