/*
 * Decompiled with CFR 0.152.
 */
package de.pixelmedien.adventure.game.animation;

import java.util.Objects;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;

public class SpriteLoader {
    private final String basePath;

    public SpriteLoader(String basePath) {
        this.basePath = basePath;
    }

    public Image[] loadWalkUpFrames() {
        return this.loadFrames("walk-up.png", 4, 32, 32);
    }

    public Image[] loadWalkDownFrames() {
        return this.loadFrames("walk-down.png", 4, 32, 32);
    }

    public Image[] loadWalkLeftFrames() {
        return this.loadFrames("walk-left.png", 4, 32, 32);
    }

    public Image[] loadWalkRightFrames() {
        return this.loadFrames("walk-right.png", 4, 32, 32);
    }

    public Image loadIdleFrame() {
        return new Image(Objects.requireNonNull(this.getClass().getResourceAsStream(this.basePath + "idle.png")));
    }

    private Image[] loadFrames(String spriteSheet, int frameCount, int width, int height) {
        Image sheet = new Image(Objects.requireNonNull(this.getClass().getResourceAsStream(this.basePath + spriteSheet)));
        Image[] frames = new Image[frameCount];
        for (int i = 0; i < frameCount; ++i) {
            frames[i] = new WritableImage(sheet.getPixelReader(), i * width, 0, width, height);
        }
        return frames;
    }
}

