/*
 * Decompiled with CFR 0.152.
 */
package de.pixelmedien.adventure.game.animation;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.Duration;

public class SpriteAnimation {
    private final ImageView view;
    private final Image[] frames;
    private final Duration frameDuration;
    private Timeline timeline;

    public SpriteAnimation(ImageView view, Image[] frames, Duration frameDuration) {
        this.view = view;
        this.frames = frames;
        this.frameDuration = frameDuration;
    }

    public void play() {
        this.stop();
        this.timeline = new Timeline();
        for (int i = 0; i < this.frames.length; ++i) {
            int index = i;
            this.timeline.getKeyFrames().add(new KeyFrame(this.frameDuration.multiply(i), event -> this.view.setImage(this.frames[index]), new KeyValue[0]));
        }
        this.timeline.setCycleCount(-1);
        this.timeline.play();
    }

    public void stop() {
        if (this.timeline != null) {
            this.timeline.stop();
            this.timeline = null;
        }
    }
}

