/*
 * Decompiled with CFR 0.152.
 */
package de.pixelmedien.adventure;

import de.pixelmedien.adventure.game.audio.SoundController;
import de.pixelmedien.adventure.game.player.Player;
import de.pixelmedien.adventure.game.player.PlayerController;
import de.pixelmedien.adventure.ui.SceneController;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.scene.image.ImageView;
import javafx.scene.text.Font;
import javafx.stage.Stage;

public class Main
extends Application {
    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());
    private static final String GAME_FONT_PATH = "/fonts/PressStart2P-Regular.ttf";
    private static final double GAME_FONT_SIZE = 14.0;
    private static final String START_SCENE_PATH = "/ui/start.fxml";
    private static final String START_WINDOW_TITLE = "Who Am I - Start";
    private static final String START_MUSIC = "start-theme.mp3";

    public static void main(String[] args) {
        Main.launch(args);
    }

    @Override
    public void start(Stage stage) {
        SoundController soundController = new SoundController();
        SceneController sceneController = Main.createSceneController(stage, soundController);
        try (InputStream fontStream = this.getClass().getResourceAsStream(GAME_FONT_PATH);){
            if (fontStream == null) {
                LOGGER.warning("Game Font nicht gefunden unter: /fonts/PressStart2P-Regular.ttf");
                return;
            }
            Font.loadFont(fontStream, 14.0);
            LOGGER.info("Game Font erfolgreich geladen.");
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Fehler beim Laden der Game Font", exception);
        }
        try {
            sceneController.setScene(START_SCENE_PATH, START_WINDOW_TITLE);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Fehler beim Laden der Startszene", exception);
        }
        stage.setResizable(false);
        stage.setWidth(1024.0);
        stage.setHeight(760.0);
        if (!stage.isShowing()) {
            stage.show();
        }
        try {
            soundController.playMusic(START_MUSIC, true);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Fehler beim Starten der Musik", exception);
        }
    }

    private static SceneController createSceneController(Stage stage, SoundController soundController) {
        ImageView dummyAvatar = new ImageView();
        Player player = new Player("Held", dummyAvatar, null);
        PlayerController playerController = new PlayerController(player);
        SceneController sceneController = new SceneController(stage, soundController, playerController);
        return sceneController;
    }
}

