/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.text;

import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.text.GlyphLayout;
import java.util.concurrent.atomic.AtomicBoolean;

public class GlyphLayoutManager {
    private static final GlyphLayout REUSABLE_INSTANCE = GlyphLayoutManager.newInstance();
    private static final AtomicBoolean IN_USE = new AtomicBoolean(false);

    private static GlyphLayout newInstance() {
        PrismFontFactory prismFontFactory = PrismFontFactory.getFontFactory();
        return prismFontFactory.createGlyphLayout();
    }

    public static GlyphLayout getInstance() {
        if (IN_USE.compareAndSet(false, true)) {
            return REUSABLE_INSTANCE;
        }
        return GlyphLayoutManager.newInstance();
    }

    public static void dispose(GlyphLayout glyphLayout) {
        if (glyphLayout == REUSABLE_INSTANCE) {
            IN_USE.set(false);
        }
    }
}

