/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.parser;

import com.sun.javafx.css.parser.Token;
import java.util.List;
import java.util.function.Predicate;

public final class TokenStream {
    private final List<Token> source;
    private final int size;
    private int currentIndex = -1;
    private Token currentItem;

    public TokenStream(List<Token> list) {
        this.source = list;
        this.size = list.size();
    }

    public int size() {
        return this.size;
    }

    public Token current() {
        return this.currentItem;
    }

    public Token consume() {
        if (this.currentIndex < this.size - 1) {
            this.currentItem = this.source.get(++this.currentIndex);
            return this.currentItem;
        }
        if (this.currentIndex < this.size) {
            ++this.currentIndex;
        }
        return null;
    }

    public Token consumeIf(Predicate<Token> predicate) {
        Token token = this.consume();
        if (token != null && predicate.test(token)) {
            return token;
        }
        this.reconsume();
        return null;
    }

    public void reconsume() {
        if (this.currentIndex > 0) {
            this.currentItem = this.source.get(--this.currentIndex);
        } else {
            this.currentItem = null;
            this.currentIndex = -1;
        }
    }

    public Token peek() {
        return this.currentIndex < this.size - 1 ? this.source.get(this.currentIndex + 1) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SafeVarargs
    public final boolean matches(Predicate<Token> ... predicateArray) {
        Token token;
        boolean bl;
        block4: {
            boolean bl2;
            int n = this.currentIndex;
            try {
                for (Predicate<Token> predicate : predicateArray) {
                    if (this.consumeIf(predicate) != null) continue;
                    bl = false;
                    this.currentIndex = n;
                    token = n >= 0 ? this.source.get(n) : null;
                    break block4;
                }
                bl2 = true;
                this.currentIndex = n;
                this.currentItem = n >= 0 ? this.source.get(n) : null;
            }
            catch (Throwable throwable) {
                this.currentIndex = n;
                this.currentItem = n >= 0 ? this.source.get(n) : null;
                throw throwable;
            }
            return bl2;
        }
        this.currentItem = token;
        return bl;
    }
}

