/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext.rtf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

abstract class AbstractFilter
extends OutputStream {
    protected char[] translationTable = latin1TranslationTable;
    protected boolean[] specialsTable = noSpecialsTable;
    static final char[] latin1TranslationTable;
    static final boolean[] noSpecialsTable;
    static final boolean[] allSpecialsTable;

    public void readFromStream(InputStream inputStream) throws IOException {
        inputStream.transferTo(this);
    }

    public void readFromReader(Reader reader) throws IOException {
        int n;
        char[] cArray = new char[2048];
        while ((n = reader.read(cArray)) >= 0) {
            for (int i = 0; i < n; ++i) {
                this.write(cArray[i]);
            }
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.specialsTable[n &= 0xFF]) {
            this.writeSpecial(n);
        } else {
            char c = this.translationTable[n];
            if (c != '\u0000') {
                this.write(c);
            }
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        StringBuilder stringBuilder = null;
        while (n2 > 0) {
            int n3 = byArray[n] & 0xFF;
            if (this.specialsTable[n3]) {
                if (stringBuilder != null) {
                    this.write(stringBuilder.toString());
                    stringBuilder = null;
                }
                this.writeSpecial(n3);
            } else {
                char c = this.translationTable[n3];
                if (c != '\u0000') {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                    }
                    stringBuilder.append(c);
                }
            }
            --n2;
            ++n;
        }
        if (stringBuilder != null) {
            this.write(stringBuilder.toString());
        }
    }

    public void write(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.write(string.charAt(i));
        }
    }

    protected abstract void write(char var1) throws IOException;

    protected abstract void writeSpecial(int var1) throws IOException;

    static {
        int n;
        noSpecialsTable = new boolean[256];
        for (n = 0; n < 256; ++n) {
            AbstractFilter.noSpecialsTable[n] = false;
        }
        allSpecialsTable = new boolean[256];
        for (n = 0; n < 256; ++n) {
            AbstractFilter.allSpecialsTable[n] = true;
        }
        latin1TranslationTable = new char[256];
        for (n = 0; n < 256; ++n) {
            AbstractFilter.latin1TranslationTable[n] = (char)n;
        }
    }
}

