/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import jfx.incubator.scene.control.richtext.RichTextArea;
import jfx.incubator.scene.control.richtext.SelectionSegment;
import jfx.incubator.scene.control.richtext.TextPos;

public class RTAccessibilityHelper {
    private final RichTextArea control;
    private TextPos start;
    private TextPos end;

    public RTAccessibilityHelper(RichTextArea richTextArea) {
        this.control = richTextArea;
    }

    private void p(String string, Object ... objectArray) {
    }

    public void handleModelChange() {
        this.p("handleModelChange", new Object[0]);
        this.start = null;
        this.end = null;
    }

    public boolean handleTextUpdate(TextPos textPos, TextPos textPos2) {
        this.p("handleTextUpdate %s %s", this.start, this.end);
        if (this.start != null && this.end != null) {
            return textPos.compareTo(this.end) < 0;
        }
        return false;
    }

    public boolean handleSelectionChange(SelectionSegment selectionSegment) {
        if (selectionSegment == null) {
            return false;
        }
        if (this.start == null || this.end == null || this.isOutside(selectionSegment.getMin(), selectionSegment.getMax())) {
            this.createWindow();
            return true;
        }
        return false;
    }

    private boolean isOutside(TextPos textPos, TextPos textPos2) {
        return this.start.compareTo(textPos2) >= 0 || this.end.compareTo(textPos) <= 0;
    }

    private void createWindow() {
        SelectionSegment selectionSegment = this.control.getSelection();
        TextPos textPos = selectionSegment.getCaret();
        int n = Math.max(0, textPos.index() - 32);
        int n2 = Math.min(this.control.getParagraphCount() - 1, n + 64);
        this.start = TextPos.ofLeading(n, 0);
        this.end = this.control.getParagraphEnd(n2);
    }

    public String getText() {
        if (this.start == null && this.end == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.end.index();
        for (int i = this.start.index(); i <= n; ++i) {
            String string = this.control.getPlainText(i);
            stringBuilder.append(string).append("\n");
        }
        return stringBuilder.toString();
    }

    public Integer selectionStart() {
        SelectionSegment selectionSegment = this.control.getSelection();
        if (selectionSegment == null) {
            return null;
        }
        return this.computeOffset(selectionSegment.getMin());
    }

    public Integer selectionEnd() {
        SelectionSegment selectionSegment = this.control.getSelection();
        if (selectionSegment == null) {
            return null;
        }
        return this.computeOffset(selectionSegment.getMax());
    }

    public Integer caretOffset() {
        SelectionSegment selectionSegment = this.control.getSelection();
        if (selectionSegment == null) {
            return null;
        }
        return this.computeOffset(selectionSegment.getCaret());
    }

    private Integer computeOffset(TextPos textPos) {
        if (this.start == null || this.end == null || textPos.compareTo(this.start) < 0 || textPos.compareTo(this.end) > 0) {
            return null;
        }
        int n = 0;
        for (int i = this.start.index(); i < textPos.index(); ++i) {
            String string = this.control.getPlainText(i);
            n += string.length() + 1;
        }
        return n + textPos.offset();
    }
}

